/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.ast;

import org.mozilla.javascript.ast.AstNode;
import org.mozilla.javascript.ast.NodeVisitor;

public class ExpressionStatement
extends AstNode {
    private AstNode expr;

    public void setHasResult() {
        this.type = 134;
    }

    public ExpressionStatement() {
        this.type = 133;
    }

    public ExpressionStatement(AstNode expr2, boolean hasResult) {
        this(expr2);
        if (hasResult) {
            this.setHasResult();
        }
    }

    public ExpressionStatement(AstNode expr2) {
        this(expr2.getPosition(), expr2.getLength(), expr2);
    }

    public ExpressionStatement(int pos, int len) {
        super(pos, len);
        this.type = 133;
    }

    public ExpressionStatement(int pos, int len, AstNode expr2) {
        super(pos, len);
        this.type = 133;
        this.setExpression(expr2);
    }

    public AstNode getExpression() {
        return this.expr;
    }

    public void setExpression(AstNode expression) {
        this.assertNotNull(expression);
        this.expr = expression;
        expression.setParent(this);
        this.setLineno(expression.getLineno());
    }

    public boolean hasSideEffects() {
        return this.type == 134 || this.expr.hasSideEffects();
    }

    public String toSource(int depth) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.expr.toSource(depth));
        sb.append(";\n");
        return sb.toString();
    }

    public void visit(NodeVisitor v) {
        if (v.visit(this)) {
            this.expr.visit(v);
        }
    }
}

